/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.WWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class WCardPanel
extends WPanel {
    private final List<WWidget> cards = new ArrayList<WWidget>();
    private int selectedIndex = 0;

    public void add(WWidget card) {
        this.add(this.cards.size(), card);
    }

    public void add(int index, WWidget card) {
        this.cards.add(index, card);
        card.setParent(this);
        card.setLocation(0, 0);
        this.expandToFit(card);
    }

    public void add(WWidget card, int width, int height) {
        this.add(this.cards.size(), card, width, height);
    }

    public void add(int index, WWidget card, int width, int height) {
        if (card.canResize()) {
            card.setSize(width, height);
        }
        this.add(index, card);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public WCardPanel setSelectedIndex(int selectedIndex) {
        if (selectedIndex < 0 || selectedIndex >= this.cards.size()) {
            throw new IndexOutOfBoundsException("Card index " + selectedIndex + " out of bounds: 0 <= index <" + this.cards.size());
        }
        if (this.selectedIndex != selectedIndex) {
            this.selectedIndex = selectedIndex;
            this.layout();
        }
        return this;
    }

    public WWidget getSelectedCard() {
        return this.cards.get(this.getSelectedIndex());
    }

    public WCardPanel setSelectedCard(WWidget selectedCard) {
        if (!this.cards.contains(selectedCard)) {
            throw new NoSuchElementException("Widget " + String.valueOf(selectedCard) + " is not a card in this panel!");
        }
        return this.setSelectedIndex(this.cards.indexOf(selectedCard));
    }

    public int getCardCount() {
        return this.cards.size();
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        for (WWidget card : this.cards) {
            card.setSize(x, y);
        }
    }

    @Override
    public void layout() {
        this.children.clear();
        for (WWidget child : this.cards) {
            if (child instanceof WPanel) {
                WPanel panel = (WPanel)child;
                panel.layout();
            }
            child.refresh();
            this.expandToFit(child);
            if (child == this.getSelectedCard()) {
                child.onShown();
                continue;
            }
            child.onHidden();
        }
        for (WWidget child : this.cards) {
            child.setSize(this.getWidth(), this.getHeight());
        }
        this.children.add(this.getSelectedCard());
    }

    @Override
    public void validate(GuiDescription c) {
        if (this.cards.isEmpty()) {
            throw new IllegalStateException("No children in card panel");
        }
        this.layout();
        for (WWidget card : this.cards) {
            card.validate(c);
            if (this.getSelectedCard() == card) continue;
            card.onHidden();
        }
    }

    @Override
    public void addPainters() {
        for (WWidget card : this.cards) {
            card.addPainters();
        }
    }
}

